#define FXAA_PC 1
#define FXAA_HLSL_4 1
//#define FXAA_GREEN_AS_LUMA 1
#define FXAA_QUALITY__PRESET 39
//#define FXAA_QUALITY__PRESET 12

#include "Fxaa3_11.h"

Texture2D	gScreenTexture : register( t0 );
Texture2D	gLumaTexture : register( t1 );
SamplerState screenSampler : register( s0 );

//Difinitions: BUFFER_WIDTH, BUFFER_HEIGHT, BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT

struct PS_INPUT
{
	float2 vTexcoord	: TEXCOORD0;
};
struct VS_Output
{
    float4 Pos : SV_POSITION;
    float2 Tex : TEXCOORD0;
};
struct VS_Input
{
    float4 Pos : POSITION;
    float2 Tex : TEXCOORD0;
};

VS_Output VSMain( VS_Input Input )
{
	VS_Output Output;
    Output.Pos = Input.Pos;
	Output.Tex = Input.Tex;
	return Output;
}

#include "Sharpen.h" 

float4 LumaShader( VS_Output Input ) : SV_TARGET
{
#ifdef USE_ADDITIONAL_SHADER
    float4 c0 = main(Input.Tex);
#else
    float4 c0 = gScreenTexture.SampleLevel( screenSampler, Input.Tex, 0 );
#endif
    //c0.w = dot(c0.xyz,float3(0.299, 0.587, 0.114)); //store luma in alpha
      c0.w = sqrt(dot(c0.xyz,float3(0.150, 0.296, 0.228))); //store luma in alpha
    return c0;
}
float4 MyShader( VS_Output Input ) : SV_TARGET
{
    FxaaTex t = { screenSampler, gLumaTexture };
    float4 c0 = FxaaPixelShader(
		Input.Tex, //pos
		0, //fxaaConsolePosPos (?)
		t, //tex
		t, //fxaaConsole360TexExpBiasNegOne
		t, //fxaaConsole360TexExpBiasNegTwo
		float2(BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT), //fxaaQualityRcpFrame
		float4(-0.5*BUFFER_RCP_WIDTH,-0.5*BUFFER_RCP_HEIGHT,0.5*BUFFER_RCP_WIDTH,0.5*BUFFER_RCP_HEIGHT), //fxaaConsoleRcpFrameOpt
		float4(-2.0*BUFFER_RCP_WIDTH,-2.0*BUFFER_RCP_HEIGHT,2.0*BUFFER_RCP_WIDTH,2.0*BUFFER_RCP_HEIGHT), //fxaaConsoleRcpFrameOpt2
		float4(8.0*BUFFER_RCP_WIDTH,8.0*BUFFER_RCP_HEIGHT,-4.0*BUFFER_RCP_WIDTH,-4.0*BUFFER_RCP_HEIGHT), //fxaaConsole360RcpFrameOpt2
		0.75, //fxaaQualitySubpix (default: 0.75)
		0.080, //fxaaQualityEdgeThreshold
		0.0725, //fxaaQualityEdgeThresholdMin
		8.0, //fxaaConsoleEdgeSharpness
		0.125, //fxaaConsoleEdgeThreshold
		0.05, //fxaaConsoleEdgeThresholdMin
		0 //fxaaConsole360ConstDir
	);
    c0.w = 1;
    return c0;
}

